<%@ Control Language="c#" AutoEventWireup="false" Codebehind="Active.ascx.cs" Inherits="Mediachase.UI.Web.Modules.Active" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="sep" src="..\Modules\Separator2.ascx"%>
<script language="javascript">
function ProjectClick(Id)
{
	window.top.right.location.href = "../Projects/ProjectView.aspx?ProjectId=" + Id;
}
function TaskToDoClick(Id, IsToDo)
{
	if (IsToDo)
		window.top.right.location.href = "../ToDo/ToDoView.aspx?ToDoId=" + Id;
	else
		window.top.right.location.href = "../Tasks/TaskView.aspx?TaskId=" + Id;
}
function IncidentClick(Id)
{
	window.top.right.location.href = "../Incidents/IncidentView.aspx?IncidentId=" + Id;
}
function DocumentClick(Id)
{
	window.top.right.location.href = "../Documents/DocumentView.aspx?DocumentId=" + Id;
}
</script>

<ibn:sep id="Sep1" runat="server"></ibn:sep>
<asp:Panel ID="Pan1" Runat="server">
	<asp:DataGrid id="dgActiveProjects"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="False" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ProjectClick(<%# DataBinder.Eval(Container.DataItem, "ProjectId") %>)'>
						<tr>
							<td width="30px" align="center"><%# Mediachase.UI.Web.Util.CommonHelper.GetPriorityIcon((int)DataBinder.Eval(Container.DataItem, "PriorityId"), (string)DataBinder.Eval(Container.DataItem, "PriorityName"))%></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %> (#<%# DataBinder.Eval(Container.DataItem, "ProjectId") %>)
							</td>
							<td width="120px">
								<table cellspacing="0" cellpadding="0" border="1" bordercolor="Black" border="0" style="font: 1;width:50;margin-top:5; border: solid 0 0;" align="left">
									<tr style="font: 1;">
										<td style="font: 1;background: #ffffff;"><img  border="0" src="../Layouts/images/point.gif" width='<%# DataBinder.Eval(Container.DataItem, "PercentCompleted")%>%' height="3"></td>
									</tr>
								</table>&nbsp;<%# DataBinder.Eval(Container.DataItem, "PercentCompleted")%>%
							</td>
							<td width="200px">
								<%= LocRM.GetString("from") %> <%# ((DateTime)DataBinder.Eval(Container.DataItem, "TargetStartDate")).ToShortDateString() %>
								<%= LocRM.GetString("till") %> <%# ((DateTime)DataBinder.Eval(Container.DataItem, "TargetFinishDate")).ToShortDateString() %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep2" runat="server"></ibn:sep>
<asp:Panel ID="Pan2" Runat="server">
	<asp:datagrid id="dgActiveTaskToDo" Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false"  EnableViewState="false" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
						onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
						onclick='TaskToDoClick(<%# DataBinder.Eval(Container.DataItem, "ItemId") %>, <%# DataBinder.Eval(Container.DataItem, "IsToDo") %>)'>
						<tr>
							<td width="30" align="center">
								<%# GetPriorityIcon((int)DataBinder.Eval(Container.DataItem, "PriorityId"), (string)DataBinder.Eval(Container.DataItem, "PriorityName"))%>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
							<td width="120">
								<table cellspacing="0" cellpadding="0" border="1" bordercolor="Black" border="0" style="font: 1;width:50;margin-top:5; border: solid 0 0;" align="left">
									<tr style="font: 1;">
										<td style="font: 1;background: #ffffff;"><img  border="0" src="../Layouts/images/point.gif" width='<%# DataBinder.Eval(Container.DataItem, "PercentCompleted")%>%' height="3"></td>
									</tr>
								</table>&nbsp;<%# DataBinder.Eval(Container.DataItem, "PercentCompleted")%>%
							</td>
							<td width="200px">
								<%# GetInterval(DataBinder.Eval(Container.DataItem, "StartDate"), DataBinder.Eval(Container.DataItem, "FinishDate")) %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:datagrid>
</asp:Panel>

<ibn:sep id="Sep3" runat="server"></ibn:sep>
<asp:Panel ID="Pan3" Runat="server">
	<asp:datagrid id="dgActiveIncidents" Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false"  EnableViewState="false" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
						onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
						onclick='IncidentClick(<%# DataBinder.Eval(Container.DataItem, "IncidentId") %>)'>
						<tr>
							<td width="30" align="center">
								<%# GetPriorityIcon((int)DataBinder.Eval(Container.DataItem, "PriorityId"), (string)DataBinder.Eval(Container.DataItem, "PriorityName"))%>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %> (#<%# DataBinder.Eval(Container.DataItem, "IncidentId") %>)
							</td>
							<td width="200px">
								<%= LocRM.GetString("from")%>
								<%# ((DateTime)DataBinder.Eval(Container.DataItem, "CreationDate")).ToShortDateString() %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:datagrid>
</asp:Panel>

<ibn:sep id="Sep4" runat="server"></ibn:sep>
<asp:Panel ID="Pan4" Runat="server">
	<asp:datagrid id="dgActiveDocuments" Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false"  EnableViewState="false" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
						onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
						onclick='DocumentClick(<%# DataBinder.Eval(Container.DataItem, "DocumentId") %>)'>
						<tr>
							<td width="30" align="center">
								<%# GetPriorityIcon((int)DataBinder.Eval(Container.DataItem, "PriorityId"), (string)DataBinder.Eval(Container.DataItem, "PriorityName"))%>
							</td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
							<td width="200px">
								<%= LocRM.GetString("from")%>
								<%# ((DateTime)DataBinder.Eval(Container.DataItem, "CreationDate")).ToShortDateString() %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:datagrid>
</asp:Panel>